/*
 * Decompiled with CFR 0.152.
 */
package glodblock.com.github.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import glodblock.com.github.orevisualdetector.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class HandlerOreData {
    public static HashMap<String, short[]> mOreDictMap = new HashMap();
    public static HashMap<String, short[]> mUnlocalizedMap = new HashMap();
    public static HashMap<String, Short> mNameToIDMap = new HashMap();
    public static HashMap<Short, String> mIDToNameMap = new HashMap();
    public static HashMap<Short, String> mIDToDisplayNameMap = new HashMap();

    public static String readJsonFile() {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("assets/orevisualdetector/data/data.json");
            return HandlerOreData.readStream(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String tryReadJsonFile() {
        try {
            URL url = new File(new File(new File((File)FMLInjectionData.data()[6], "config"), "OreVisualDetector"), "CustomOreColorMap.json").toURI().toURL();
            return HandlerOreData.readStream(url);
        }
        catch (Exception e) {
            try {
                File tFile = new File(new File(new File((File)FMLInjectionData.data()[6], "config"), "OreVisualDetector"), "CustomOreColorMap.json");
                if (tFile.createNewFile()) {
                    FileOutputStream tOut = new FileOutputStream(tFile, true);
                    String tBuffer = "{\n  \"OreColorMap\":[\n  ]\n}\n";
                    tOut.write(tBuffer.getBytes(StandardCharsets.UTF_8));
                    tOut.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static String readStream(URL url) throws IOException {
        String s;
        if (url == null) {
            return "";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        while ((s = in.readLine()) != null) {
            sb.append(s);
        }
        in.close();
        return sb.toString();
    }

    public static void run() {
        HandlerOreData.processColorMapData(HandlerOreData.readJsonFile());
        HandlerOreData.processColorMapData(HandlerOreData.tryReadJsonFile());
    }

    public static void processColorMapData(String data) {
        if (data == null) {
            return;
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data);
        JsonArray jsonArray = jsonObject.get("OreColorMap").getAsJsonArray();
        short cnt = 0;
        for (JsonElement elm : jsonArray) {
            JsonObject colorData = elm.getAsJsonObject();
            String oreDictName = null;
            String unlocalizedName = null;
            if (colorData.get("OreDict") != null) {
                oreDictName = colorData.get("OreDict").getAsString();
            }
            if (colorData.get("Unlocalized") != null) {
                unlocalizedName = colorData.get("Unlocalized").getAsString();
            }
            if (mNameToIDMap.containsKey(oreDictName) || mNameToIDMap.containsKey(unlocalizedName)) {
                if (oreDictName != null) {
                    Main.Logger.warn(String.format("%s is defined twice!", oreDictName));
                }
                if (unlocalizedName == null) continue;
                Main.Logger.warn(String.format("%s is defined twice!", unlocalizedName));
                continue;
            }
            if (colorData.get("Redirect") != null) {
                String tRedirect = colorData.get("Redirect").getAsString();
                short tID = mNameToIDMap.get(tRedirect);
                if (tID == 0) {
                    Main.Logger.warn(String.format("Undefined Redirect Target: %s!", colorData.get("Redirect").getAsString()));
                    continue;
                }
                if (oreDictName != null) {
                    mNameToIDMap.put(oreDictName, tID);
                    if (mOreDictMap.containsKey(tRedirect)) {
                        mOreDictMap.put(oreDictName, mOreDictMap.get(tRedirect));
                        HandlerOreData.generatorSubOre(oreDictName, mOreDictMap.get(tRedirect), tID);
                    } else if (mUnlocalizedMap.containsKey(tRedirect)) {
                        mOreDictMap.put(oreDictName, mUnlocalizedMap.get(tRedirect));
                        HandlerOreData.generatorSubOre(oreDictName, mUnlocalizedMap.get(tRedirect), tID);
                    }
                }
                if (unlocalizedName == null) continue;
                mNameToIDMap.put(unlocalizedName, tID);
                if (mOreDictMap.containsKey(tRedirect)) {
                    mUnlocalizedMap.put(unlocalizedName, mOreDictMap.get(tRedirect));
                    continue;
                }
                if (!mUnlocalizedMap.containsKey(tRedirect)) continue;
                mUnlocalizedMap.put(unlocalizedName, mUnlocalizedMap.get(tRedirect));
                continue;
            }
            short r = colorData.get("R").getAsShort();
            short g = colorData.get("G").getAsShort();
            short b = colorData.get("B").getAsShort();
            if (oreDictName != null) {
                mOreDictMap.put(oreDictName, new short[]{r, g, b});
                cnt = (short)(cnt + 1);
                mNameToIDMap.put(oreDictName, cnt);
                mIDToNameMap.put(cnt, oreDictName);
                HandlerOreData.generatorSubOre(oreDictName, new short[]{r, g, b}, cnt);
            }
            if (unlocalizedName == null) continue;
            mUnlocalizedMap.put(unlocalizedName, new short[]{r, g, b});
            cnt = (short)(cnt + 1);
            cnt = (short)(cnt + 1);
            mNameToIDMap.put(unlocalizedName, cnt);
            mIDToNameMap.put(cnt, unlocalizedName);
        }
    }

    public static void generatorSubOre(String oreDictName, short[] color, short id) {
        String subOre;
        if (!oreDictName.startsWith("oreNether") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreNether");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreEnd") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreEnd");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreGravel") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreGravel");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreNetherrack") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreNetherrack");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreEndstone") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreEndstone");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreSand") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreSand");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreBlackgranite") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreBlackgranite");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreRedgranite") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreRedgranite");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreMarble") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreMarble");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
        if (!oreDictName.startsWith("oreBasalt") && oreDictName.startsWith("ore")) {
            subOre = oreDictName.replaceFirst("ore", "oreBasalt");
            mOreDictMap.put(subOre, color);
            mNameToIDMap.put(subOre, id);
        }
    }
}

